% Function: This is the program that takes the complicated hit cell array
% and outputs the desired information in a more manageable format

% Inputs:
% HitCell - a complicated cell array that contains information about the
%    identity, number, matrix index of the significant hits
% ConditionNum - the comparison number for the condition of interest for an
%    output
% ExpNum - a numerical value for the number of experiments performed (this
%    can also be used to look at the permutations for a subset of the
%    experiments by using a smaller value)
% CombNum - a numerical value that determines the which permutation of the
%    experiments will be used (default is 1, unless measuring hits from a
%    subset of the experiments) 
% NumUnions - a numerical value that determines the consistency level
%    desired, where the number of unions represents the number of
%    experiments a pair can be non-significant 
%    (ie consistent in 3 of 4 or 4 of 4, will have NumUnions = 2)

% Outputs:
% SimpleId - the identities of the IP/Probe combinations that are deemed 
%    consistently significant given the input values
% SimpleIndex - the indices of the IP/Probe combinations that are deemed 
%    consistently significant given the input values (position in matrix)
% SimpleList - a list that separates which of the consistency level a 
%    IP/Probe combination was identified as significant in 


function [SimpleId,SimpleIndex,SimpleList] = SimpleHits(HitCell,...
    ConditionNum,ExpN,CombNum,NumUnions)

SimpleId = HitCell{ConditionNum}{1}{ExpN}{CombNum}{NumUnions};
SimpleIndex = HitCell{ConditionNum}{2}{ExpN}{CombNum}{NumUnions};
SimpleList = HitCell{ConditionNum}{4}{ExpN}{CombNum}{NumUnions};
